# Recently Changed Files

This file is automatically updated. See `setup.php` for the web interface to view changed files.

## How to Use

1. Visit `setup.php` in your browser
2. Click "Refresh File List" to see all recently modified files
3. Only upload the files listed here instead of the entire website

## File Categories

### PHP Backend Files (NEW - Converted from Node.js)
- `api/db.php` - Database class
- `api/auth.php` - Authentication
- `api/exchangeRate.php` - Exchange rates
- `api/transferService.php` - Transfer logic
- `api/session.php` - Session management
- `api/helpers.php` - Helper functions
- `api/login.php` - Login endpoint
- `api/dashboard.php` - Dashboard endpoint
- `api/transfers.php` - Transfers endpoint
- `api/transfer/lock-rate.php` - Lock rate endpoint
- `api/transfer/recipient.php` - Recipient endpoint
- `api/transfer/confirm.php` - Confirm transfer endpoint
- `api/run-script.php` - Script runner (NEW)
- `api/changed-files.php` - File list generator (NEW)
- `api/system-info.php` - System info (NEW)

### Scripts
- `scripts/create-user.php` - Create user account (PHP version)
- `scripts/check-user.php` - Check user account (NEW)

### Configuration
- `.htaccess` - Apache routing rules
- `setup.php` - Web-based setup utility (NEW)
- `README-PHP.md` - PHP setup documentation (NEW)
- `CHANGED-FILES.md` - This file (NEW)

### Removed Files (Node.js - No longer needed)
- ~~`server.js`~~ - DELETED
- ~~`package.json`~~ - DELETED
- ~~`backend/db.js`~~ - DELETED
- ~~`backend/auth.js`~~ - DELETED
- ~~`backend/exchangeRate.js`~~ - DELETED
- ~~`backend/transferService.js`~~ - DELETED
- ~~`scripts/create-user.js`~~ - DELETED

## Upload Instructions

1. Upload all files in the `api/` directory
2. Upload all files in the `scripts/` directory
3. Upload `setup.php` to the root directory
4. Upload `.htaccess` to the root directory
5. Make sure `database/` directory is writable (chmod 755)

## Notes

- The frontend HTML files (`login.html`, `dash.html`, `account.html`, `transfer.html`) remain unchanged
- No changes needed to existing CSS or JavaScript files
- The database will be created automatically when you run the create-user script

