# Vercel Deployment Checklist

Use this checklist to ensure everything is ready before deploying to Vercel.

## Pre-Deployment Checklist

- [x] ✅ Git repository initialized
- [x] ✅ `.gitignore` file created
- [x] ✅ Initial commit made
- [x] ✅ `vercel.json` configuration file exists
- [x] ✅ PostgreSQL conversion completed
- [x] ✅ Database schema file created (`database/schema-postgres.sql`)
- [x] ✅ All API files updated to use PostgreSQL

## Vercel Setup Steps

### Step 1: Install Vercel CLI
```bash
npm install -g vercel
```

### Step 2: Login to Vercel
```bash
vercel login
```

### Step 3: Create Vercel Postgres Database
1. Go to https://vercel.com/dashboard
2. Click **Storage** → **Create Database**
3. Select **Postgres**
4. Choose a name (e.g., "wise-db")
5. Select region closest to your users
6. Click **Create**

### Step 4: Deploy Project
```bash
cd "C:\Users\user\Documents\workspace\mr carter\sites\other sites\rpc irish\demo wise\wise.com"
vercel
```

When prompted:
- **Set up and deploy?** → Yes
- **Which scope?** → Select your account
- **Link to existing project?** → No
- **Project name?** → wise-app (or your preferred name)
- **Directory?** → ./
- **Override settings?** → No

### Step 5: Link Database to Project
1. Go to your project in Vercel dashboard
2. Click **Storage** tab
3. Click **Connect Database**
4. Select your Postgres database
5. Click **Connect**

This automatically adds environment variables:
- `POSTGRES_HOST`
- `POSTGRES_DATABASE`
- `POSTGRES_USER`
- `POSTGRES_PASSWORD`
- `POSTGRES_PORT`
- `POSTGRES_URL`

### Step 6: Initialize Database Schema

**Option A: Auto-create (Easiest)**
- Just visit any API endpoint that uses Database class
- Tables will be created automatically

**Option B: Manual Import (Recommended)**
1. Get connection details from Vercel dashboard
2. Connect using PostgreSQL client (pgAdmin, DBeaver, etc.)
3. Run `database/schema-postgres.sql`

### Step 7: Test Deployment

Test these URLs after deployment:
- Database test: `https://your-project.vercel.app/api/test-postgres.php`
- System info: `https://your-project.vercel.app/api/system-info.php`
- Login: `https://your-project.vercel.app/api/login.php`
- Frontend: `https://your-project.vercel.app/index.html`

## Post-Deployment Checklist

- [ ] Database connection test passes
- [ ] API endpoints respond correctly
- [ ] Frontend loads properly
- [ ] Database tables created successfully
- [ ] Environment variables verified in Vercel dashboard
- [ ] Logs checked for any errors

## Troubleshooting

### Database Connection Issues
- Verify environment variables in Vercel dashboard
- Check database is linked to project
- Review function logs in Vercel dashboard

### Tables Not Created
- Visit an API endpoint that uses Database class
- Or manually run schema SQL file

### 404 Errors
- Check `vercel.json` routing configuration
- Verify API files are in `api/` directory
- Check deployment logs

## Next Steps

1. Set up GitHub integration for automatic deployments
2. Configure custom domain (optional)
3. Set up monitoring and error tracking
4. Review and optimize for performance

---

**Your project is now ready for Vercel deployment!** 🚀

