# Migrating from SQLite to MySQL

If you're experiencing issues with SQLite (file permissions, hosting restrictions), you can switch to MySQL.

## Steps to Migrate:

### 1. Create MySQL Database
- Log into phpMyAdmin
- Create a new database (e.g., `wise_bank`)
- Note your database credentials:
  - Host: usually `localhost`
  - Database name: `wise_bank`
  - Username: your MySQL username
  - Password: your MySQL password

### 2. Update Database Configuration

Edit `api/db-mysql.php` and update these lines:
```php
$this->host = 'localhost'; // Your MySQL host
$this->dbname = 'wise_bank'; // Your database name
$this->username = 'your_username'; // Your MySQL username
$this->password = 'your_password'; // Your MySQL password
```

### 3. Switch to MySQL

**Option A: Update existing files to use MySQL**

1. Rename `api/db.php` to `api/db-sqlite.php` (backup)
2. Rename `api/db-mysql.php` to `api/db.php`
3. Update the class name in `api/db.php` from `DatabaseMySQL` to `Database`

**Option B: Use a config file (Recommended)**

Create `api/config.php`:
```php
<?php
define('DB_TYPE', 'mysql'); // or 'sqlite'
define('DB_HOST', 'localhost');
define('DB_NAME', 'wise_bank');
define('DB_USER', 'your_username');
define('DB_PASS', 'your_password');
```

Then modify `api/db.php` to check the config and use the appropriate database class.

### 4. Test the Connection

Create a test file `api/test-db.php`:
```php
<?php
require_once 'db.php';
try {
    $db = new Database();
    echo "✅ Database connection successful!";
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage();
}
```

### 5. Migrate Existing Data (if any)

If you have existing SQLite data, you'll need to export and import it:
1. Export data from SQLite
2. Import into MySQL (adjust data types if needed)

## Advantages of MySQL:
- ✅ Better hosting compatibility
- ✅ No file permission issues
- ✅ Better performance for larger datasets
- ✅ Easier to backup and manage
- ✅ Better concurrent access handling

## Keep SQLite for:
- Local development
- Simple deployments
- When file-based storage is preferred

