# Wise.com Banking Platform - PHP Backend

This is a PHP-based banking platform with SQLite database. No Node.js required!

## Setup

### 1. Requirements
- PHP 7.4 or higher
- SQLite extension enabled
- Apache/Nginx with mod_rewrite (or similar)

### 2. Create Database and User Account

Run the create-user script:

```bash
php scripts/create-user.php
```

This will:
- Create the `database/` folder
- Create the SQLite database
- Create the user account for Shantelle Margret Dixon
- Set username: `shante99`
- Set password: `Shantel9921//`
- Set balance: 8,899,276.66 AUD

### 3. Configure Web Server

#### Apache
Make sure `mod_rewrite` is enabled. The `.htaccess` file is already configured.

#### Nginx
Add this to your server block:

```nginx
location / {
    try_files $uri $uri/ /index.html;
}

location /api {
    try_files $uri =404;
    fastcgi_pass unix:/var/run/php/php-fpm.sock;
    fastcgi_index index.php;
    include fastcgi_params;
    fastcgi_param SCRIPT_FILENAME $document_root$fastcgi_script_name;
}
```

### 4. Set Permissions

Make sure the `database/` folder is writable:

```bash
chmod 755 database/
chmod 644 database/bank.db
```

## File Structure

```
/
├── api/
│   ├── db.php              # Database class
│   ├── auth.php            # Authentication
│   ├── exchangeRate.php    # Exchange rate calculations
│   ├── transferService.php # Transfer logic
│   ├── session.php         # Session management
│   ├── helpers.php         # Helper functions
│   ├── login.php           # Login endpoint
│   ├── dashboard.php       # Dashboard endpoint
│   ├── transfers.php       # Transfers list endpoint
│   └── transfer/
│       ├── lock-rate.php   # Lock exchange rate
│       ├── recipient.php   # Submit recipient details
│       └── confirm.php     # Confirm and execute transfer
├── database/
│   └── bank.db            # SQLite database (created automatically)
├── scripts/
│   └── create-user.php    # Create user account script
├── .htaccess              # Apache rewrite rules
└── [HTML files...]
```

## API Endpoints

All endpoints return JSON.

### POST /api/login
Login with username and password.

**Request:**
```json
{
  "username": "shante99",
  "password": "Shantel9921//"
}
```

**Response:**
```json
{
  "success": true,
  "user": { ... },
  "sessionId": "session_..."
}
```

### GET /api/dashboard
Get user dashboard data (requires Authorization header).

**Headers:**
```
Authorization: session_...
```

**Response:**
```json
{
  "user": { ... },
  "accounts": [ ... ],
  "totalBalance": 8899276.66,
  "recentTransfers": [ ... ]
}
```

### POST /api/transfer/lock-rate
Lock exchange rate for transfer.

**Request:**
```json
{
  "sendAmount": 100,
  "fromCurrency": "AUD",
  "toCurrency": "USD"
}
```

### POST /api/transfer/recipient
Submit recipient details.

### POST /api/transfer/confirm
Confirm and execute transfer.

## Login Credentials

- **Username:** `shante99`
- **Password:** `Shantel9921//`

## Notes

- Sessions are stored in-memory (will be lost on server restart)
- For production, consider using PHP sessions or Redis
- Database is SQLite - no separate database server needed
- All API endpoints require the `Authorization` header with session ID

