# Vercel Deployment Guide

This project is configured for deployment on Vercel with PostgreSQL.

## Quick Start

1. **Install Vercel CLI** (if not already installed):
   ```bash
   npm install -g vercel
   ```

2. **Login to Vercel**:
   ```bash
   vercel login
   ```

3. **Create Vercel Postgres Database**:
   - Go to https://vercel.com/dashboard
   - Navigate to Storage → Create Database → Postgres
   - Create your database and note the credentials

4. **Deploy to Vercel**:
   ```bash
   vercel
   ```
   Follow the prompts to deploy your project.

5. **Link Database to Project**:
   - In Vercel dashboard, go to your project
   - Navigate to Storage → Connect Database
   - Select your Postgres database

6. **Initialize Database Schema**:
   - Tables will auto-create on first API call, OR
   - Manually run `database/schema-postgres.sql` using a PostgreSQL client

## Environment Variables

Vercel automatically sets these when you link the Postgres database:
- `POSTGRES_HOST`
- `POSTGRES_DATABASE`
- `POSTGRES_USER`
- `POSTGRES_PASSWORD`
- `POSTGRES_PORT`
- `POSTGRES_URL`

## Testing

After deployment, test your database connection:
- Visit: `https://your-project.vercel.app/api/test-postgres.php`

## Project Structure

- `vercel.json` - Vercel configuration
- `api/` - PHP API endpoints (serverless functions)
- `*.html` - Static frontend files
- `database/schema-postgres.sql` - PostgreSQL schema

## Notes

- PHP sessions may not persist across serverless invocations
- Use `SessionManager` class for database-backed sessions
- All database connections use PostgreSQL via PDO

