# Archive - PHP Files

This directory contains the original PHP files that were converted to Node.js/Express.

## Structure

- `php-api/` - Original PHP API endpoints and classes
- `php-scripts/` - Utility PHP scripts

## Note

These files are kept for reference only. The application now runs entirely on Node.js/Express and these PHP files are no longer used.

## Files Archived

### API Files
- All original PHP API endpoints (login.php, dashboard.php, etc.)
- Database classes (db.php, db-config.php)
- Business logic classes (auth.php, exchangeRate.php, transferService.php)
- Helper files and test scripts

### Scripts
- Setup scripts
- User creation scripts
- Test scripts

## Migration

All functionality has been migrated to:
- `api/index.js` - Main Express application
- `api/routes/` - Express routes (replacing PHP endpoints)
- `api/db.js` - Database class (replacing db.php)
- `api/auth.js` - Authentication (replacing auth.php)
- `api/exchangeRate.js` - Exchange rates (replacing exchangeRate.php)
- `api/transferService.js` - Transfer service (replacing transferService.php)

