// Load environment variables (for local development)
if (process.env.NODE_ENV !== 'production') {
  require('dotenv').config();
}

// Database configuration from Vercel Postgres environment variables
const dbConfig = {
  host: process.env.POSTGRES_HOST || 'localhost',
  port: parseInt(process.env.POSTGRES_PORT || '5432', 10),
  database: process.env.POSTGRES_DATABASE || '',
  user: process.env.POSTGRES_USER || '',
  password: process.env.POSTGRES_PASSWORD || '',
  // Connection string (if provided by Vercel)
  connectionString: process.env.POSTGRES_URL,
  // Connection pool settings
  max: 20, // Maximum number of clients in the pool
  idleTimeoutMillis: 30000,
  connectionTimeoutMillis: 2000,
};

// JWT configuration
const jwtConfig = {
  secret: process.env.JWT_SECRET || 'your-secret-key-change-in-production',
  expiresIn: process.env.JWT_EXPIRES_IN || '24h',
};

// Application configuration
const appConfig = {
  nodeEnv: process.env.NODE_ENV || 'development',
  port: process.env.PORT || 3000,
};

module.exports = {
  dbConfig,
  jwtConfig,
  appConfig,
};

