const express = require('express');
const jwt = require('jsonwebtoken');
const { jwtConfig } = require('../config');
const Auth = require('../auth');
const Database = require('../db');
const router = express.Router();

// POST /api/login
router.post('/login', async (req, res, next) => {
  try {
    // TEMPORARY: Skip authentication - just return success (matching PHP implementation)
    const { username } = req.body;
    
    // Set session user ID (this is what dashboard will check)
    const userId = 1; // Default user ID for testing
    
    // Create session in database
    const db = new Database();
    const sessionId = `session_${Date.now()}_${Math.random().toString(36).substring(7)}`;
    const expiresAt = new Date(Date.now() + 24 * 60 * 60 * 1000); // 24 hours
    
    await db.setSession(sessionId, userId, expiresAt);
    
    // Also create JWT token
    const token = jwt.sign(
      { userId, username: username || 'test', user: { id: userId } },
      jwtConfig.secret,
      { expiresIn: jwtConfig.expiresIn }
    );
    
    res.json({
      success: true,
      user: {
        id: userId,
        username: username || 'test',
        full_name: 'Test User',
        email: 'test@example.com'
      },
      sessionId: sessionId,
      token: token
    });
  } catch (error) {
    next(error);
  }
});

// POST /api/logout
router.post('/logout', async (req, res, next) => {
  try {
    // Get session ID from request
    const authHeader = req.headers.authorization;
    const sessionId = authHeader || req.query.sessionId;
    
    if (sessionId) {
      const db = new Database();
      await db.deleteSession(sessionId);
    }
    
    res.json({
      success: true,
      message: 'Logged out successfully'
    });
  } catch (error) {
    next(error);
  }
});

module.exports = router;

