const express = require('express');
const { authenticate } = require('../middleware/auth');
const Database = require('../db');
const router = express.Router();

// GET /api/dashboard
router.get('/dashboard', authenticate, async (req, res, next) => {
  try {
    const userId = parseInt(req.userId, 10);

    const db = new Database();
    await db.initialize();
    const result = await db.pool.query('SELECT total_balance FROM users WHERE id = $1', [userId]);
    const user = result.rows[0];

    if (!user) {
      return res.status(404).json({
        success: false,
        error: 'User not found',
        message: 'User account not found'
      });
    }

    // Success - return balance
    res.json({
      success: true,
      balance: parseFloat(user.total_balance || 0),
      totalBalance: parseFloat(user.total_balance || 0) // Also include for compatibility with dash.html
    });
  } catch (error) {
    next(error);
  }
});

module.exports = router;

