const express = require('express');
const { authenticate } = require('../middleware/auth');
const TransferService = require('../transferService');
const router = express.Router();

// GET /api/transfers
router.get('/transfers', authenticate, async (req, res, next) => {
  try {
    const userId = parseInt(req.userId, 10);
    const transferService = new TransferService();
    const transfers = await transferService.getTransferHistory(userId);
    
    res.json({ transfers });
  } catch (error) {
    next(error);
  }
});

module.exports = router;

