# Database Structure Explanation

## Why 3 Tables?

### 1. **users** table
- Stores user login info: username, password, email, full name
- Has a `total_balance` field BUT it's NOT used (kept for compatibility)
- **Balance is NOT stored here**

### 2. **accounts** table (This is where balance is stored!)
- Stores user balance PER CURRENCY
- One user can have multiple accounts (AUD, USD, EUR, GBP, etc.)
- Each account has its own balance
- **This is where the actual balance is stored**

**Example:**
```
User ID 1 (shante99) has:
- Account 1: AUD balance = 8,899,276.66
- Account 2: USD balance = 0.00
- Account 3: EUR balance = 0.00
```

### 3. **transfers** table
- Stores transaction history
- Records all money transfers
- Shows who sent money, how much, when, etc.

## Why Separate Accounts Table?

The `accounts` table exists because:
1. **Multi-Currency Support**: Users can hold money in different currencies (AUD, USD, EUR, etc.)
2. **Better Organization**: Each currency has its own balance
3. **Real Banking Structure**: Like real banks - you have separate accounts for different currencies

## How Balance Works:

1. **User Balance** = Sum of all balances from `accounts` table for that user
2. **Displayed Balance** = Balance from `accounts` table where currency = 'AUD' (or selected currency)
3. **Total Balance** = Sum of all currency balances for the user

## Current Flow:

```
User logs in → Dashboard loads
  ↓
API calls getTotalBalance(userId)
  ↓
Sums all balances from accounts table WHERE user_id = userId
  ↓
Returns total balance to dashboard
  ↓
Dashboard displays balance
```

## The `users.total_balance` Field:

- This field exists in the schema but is **NOT updated or used**
- It's kept for backward compatibility
- The real balance is always calculated from the `accounts` table

