-- Wise Bank Database Schema (PostgreSQL)
-- Import this file into your PostgreSQL database to create all tables and test user
-- 
-- For Vercel Postgres:
-- 1. Connect to your Vercel Postgres database
-- 2. Run this SQL file to create all tables
-- 3. Tables will be created automatically on first connection if using Database class

-- Users table
CREATE TABLE IF NOT EXISTS users (
    id SERIAL PRIMARY KEY,
    full_name VARCHAR(255) NOT NULL,
    username VARCHAR(100) UNIQUE,
    email VARCHAR(255) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    total_balance DECIMAL(15,2) DEFAULT 0,
    currency VARCHAR(10) DEFAULT 'AUD',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Create indexes for users table
CREATE INDEX IF NOT EXISTS idx_users_email ON users(email);
CREATE INDEX IF NOT EXISTS idx_users_username ON users(username);

-- Accounts table
CREATE TABLE IF NOT EXISTS accounts (
    id SERIAL PRIMARY KEY,
    user_id INTEGER NOT NULL,
    currency VARCHAR(10) NOT NULL,
    balance DECIMAL(15,2) DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
    UNIQUE(user_id, currency)
);

-- Create indexes for accounts table
CREATE INDEX IF NOT EXISTS idx_accounts_user_id ON accounts(user_id);
CREATE INDEX IF NOT EXISTS idx_accounts_currency ON accounts(currency);

-- Transfers table
CREATE TABLE IF NOT EXISTS transfers (
    id SERIAL PRIMARY KEY,
    user_id INTEGER NOT NULL,
    from_currency VARCHAR(10),
    to_currency VARCHAR(10),
    send_amount DECIMAL(15,2),
    fee DECIMAL(15,2),
    exchange_rate DECIMAL(20,6),
    receive_amount DECIMAL(15,2),
    status VARCHAR(50) DEFAULT 'PENDING',
    recipient_name VARCHAR(255),
    recipient_account VARCHAR(255),
    recipient_bank VARCHAR(255),
    recipient_country VARCHAR(100),
    rate_locked_at TIMESTAMP,
    rate_expires_at TIMESTAMP,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
);

-- Create indexes for transfers table
CREATE INDEX IF NOT EXISTS idx_transfers_user_id ON transfers(user_id);
CREATE INDEX IF NOT EXISTS idx_transfers_status ON transfers(status);
CREATE INDEX IF NOT EXISTS idx_transfers_created_at ON transfers(created_at);

-- Sessions table for database-backed session storage
CREATE TABLE IF NOT EXISTS sessions (
    session_id VARCHAR(255) PRIMARY KEY,
    user_id INTEGER REFERENCES users(id) ON DELETE CASCADE,
    transfer_data JSONB,
    expires_at TIMESTAMP,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Create indexes for sessions table
CREATE INDEX IF NOT EXISTS idx_sessions_user_id ON sessions(user_id);
CREATE INDEX IF NOT EXISTS idx_sessions_expires_at ON sessions(expires_at);

-- Create test user: shante99
-- Password: Shantel9921// (plain text)
INSERT INTO users (full_name, username, email, password, total_balance, currency) VALUES
('Shantelle Margret Dixon', 'shante99', 'shantelle@wise.com', 'Shantel9921//', 8899276.66, 'AUD')
ON CONFLICT (username) DO UPDATE SET
    full_name = EXCLUDED.full_name,
    email = EXCLUDED.email,
    password = EXCLUDED.password,
    total_balance = EXCLUDED.total_balance;

-- Get the user ID for shante99 and create AUD account
INSERT INTO accounts (user_id, currency, balance) 
SELECT id, 'AUD', 8899276.66
FROM users 
WHERE username = 'shante99'
ON CONFLICT (user_id, currency) DO UPDATE SET balance = EXCLUDED.balance;

