-- Wise Bank Database Schema
-- Import this file into phpMyAdmin to create all tables and test user
-- 
-- IMPORTANT FOR SHARED HOSTING:
-- 1. Select your database in phpMyAdmin FIRST (click on it in the left sidebar)
-- 2. Then go to Import tab and upload this file
-- 3. Do NOT try to create the database - your hosting provider creates it for you

-- Users table
CREATE TABLE IF NOT EXISTS `users` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `full_name` VARCHAR(255) NOT NULL,
    `username` VARCHAR(100) UNIQUE,
    `email` VARCHAR(255) UNIQUE NOT NULL,
    `password` VARCHAR(255) NOT NULL,
    `total_balance` DECIMAL(15,2) DEFAULT 0,
    `currency` VARCHAR(10) DEFAULT 'AUD',
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX `idx_email` (`email`),
    INDEX `idx_username` (`username`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Accounts table
CREATE TABLE IF NOT EXISTS `accounts` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `user_id` INT NOT NULL,
    `currency` VARCHAR(10) NOT NULL,
    `balance` DECIMAL(15,2) DEFAULT 0,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (`user_id`) REFERENCES `users`(`id`) ON DELETE CASCADE,
    UNIQUE KEY `unique_user_currency` (`user_id`, `currency`),
    INDEX `idx_user_id` (`user_id`),
    INDEX `idx_currency` (`currency`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Transfers table
CREATE TABLE IF NOT EXISTS `transfers` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `user_id` INT NOT NULL,
    `from_currency` VARCHAR(10),
    `to_currency` VARCHAR(10),
    `send_amount` DECIMAL(15,2),
    `fee` DECIMAL(15,2),
    `exchange_rate` DECIMAL(20,6),
    `receive_amount` DECIMAL(15,2),
    `status` VARCHAR(50) DEFAULT 'PENDING',
    `recipient_name` VARCHAR(255),
    `recipient_account` VARCHAR(255),
    `recipient_bank` VARCHAR(255),
    `recipient_country` VARCHAR(100),
    `rate_locked_at` DATETIME,
    `rate_expires_at` DATETIME,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (`user_id`) REFERENCES `users`(`id`) ON DELETE CASCADE,
    INDEX `idx_user_id` (`user_id`),
    INDEX `idx_status` (`status`),
    INDEX `idx_created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Create test user: shante99
-- Password: Shantel9921// (plain text)
INSERT INTO `users` (`full_name`, `username`, `email`, `password`, `total_balance`, `currency`) VALUES
('Shantelle Margret Dixon', 'shante99', 'shantelle@wise.com', 'Shantel9921//', 8899276.66, 'AUD')
ON DUPLICATE KEY UPDATE 
    `full_name` = VALUES(`full_name`),
    `email` = VALUES(`email`),
    `password` = VALUES(`password`),
    `total_balance` = VALUES(`total_balance`);

-- Get the user ID for shante99
SET @user_id = (SELECT `id` FROM `users` WHERE `username` = 'shante99' LIMIT 1);

-- Create AUD account with initial balance for shante99
INSERT INTO `accounts` (`user_id`, `currency`, `balance`) VALUES
(@user_id, 'AUD', 8899276.66)
ON DUPLICATE KEY UPDATE `balance` = 8899276.66;
