<?php
/**
 * Create Test User Endpoint
 * Visit this URL to create the test user: shante99
 */
header('Content-Type: application/json');

require_once __DIR__ . '/db.php';
require_once __DIR__ . '/auth.php';

$fullName = 'Shantelle Margret Dixon';
$username = 'shante99';
$email = 'shantelle@wise.com';
$password = 'Shantel9921//';
$initialBalance = 8899276.66;

try {
    $db = new Database();
    $auth = new Auth();
    
    // Check if user already exists
    $existingUser = $db->getUserByUsername($username);
    
    if ($existingUser) {
        // Update existing user (plain text password)
        $stmt = $db->db->prepare("UPDATE users SET password = ? WHERE id = ?");
        $stmt->execute([$password, $existingUser['id']]);
        
        // Update balance
        $stmt = $db->db->prepare("UPDATE accounts SET balance = ? WHERE user_id = ? AND currency = 'AUD'");
        $stmt->execute([$initialBalance, $existingUser['id']]);
        
        echo json_encode([
            'success' => true,
            'message' => 'User updated successfully',
            'user' => [
                'id' => $existingUser['id'],
                'username' => $username,
                'full_name' => $fullName
            ],
            'balance' => $initialBalance
        ]);
    } else {
        // Create new user
        $user = $auth->registerUser($fullName, $username, $email, $password);
        
        // Set initial balance
        $stmt = $db->db->prepare("UPDATE accounts SET balance = ? WHERE user_id = ? AND currency = 'AUD'");
        $stmt->execute([$initialBalance, $user['id']]);
        
        echo json_encode([
            'success' => true,
            'message' => 'User created successfully',
            'user' => [
                'id' => $user['id'],
                'username' => $username,
                'full_name' => $fullName
            ],
            'balance' => $initialBalance,
            'login' => [
                'username' => $username,
                'password' => $password
            ]
        ]);
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}

