<?php

class ExchangeRate {
    private const API_KEY = '237f6e67ee2389de0cc0e4f5';
    
    private const FALLBACK_RATES = [
        'AUD' => [
            'USD' => 0.65,
            'EUR' => 0.60,
            'GBP' => 0.52,
            'NGN' => 950,
            'INR' => 54,
            'JPY' => 97
        ],
        'USD' => [
            'AUD' => 1.54,
            'EUR' => 0.93,
            'GBP' => 0.79,
            'NGN' => 1460,
            'INR' => 83,
            'JPY' => 149
        ],
        'EUR' => [
            'AUD' => 1.66,
            'USD' => 1.07,
            'GBP' => 0.85,
            'NGN' => 1570,
            'INR' => 89,
            'JPY' => 160
        ],
        'GBP' => [
            'AUD' => 1.92,
            'USD' => 1.27,
            'EUR' => 1.18,
            'NGN' => 1850,
            'INR' => 105,
            'JPY' => 189
        ]
    ];
    
    public function getLiveRate($fromCurrency, $toCurrency) {
        // If same currency, return 1
        if ($fromCurrency === $toCurrency) {
            return 1;
        }
        
        // Try ExchangeRate API v6
        try {
            $url = "https://v6.exchangerate-api.com/v6/" . self::API_KEY . "/latest/{$fromCurrency}";
            $context = stream_context_create([
                'http' => [
                    'timeout' => 5,
                    'method' => 'GET',
                    'ignore_errors' => true
                ]
            ]);
            
            $response = @file_get_contents($url, false, $context);
            if ($response !== false) {
                $data = json_decode($response, true);
                if ($data && isset($data['conversion_rates'][$toCurrency])) {
                    return floatval($data['conversion_rates'][$toCurrency]);
                }
            }
        } catch (Exception $e) {
            // Fall through to fallback
        }
        
        // Fallback to hardcoded rates
        if (isset(self::FALLBACK_RATES[$fromCurrency][$toCurrency])) {
            return self::FALLBACK_RATES[$fromCurrency][$toCurrency];
        }
        
        // If no fallback, calculate via USD
        if ($fromCurrency !== 'USD' && $toCurrency !== 'USD') {
            $toUSD = self::FALLBACK_RATES[$fromCurrency]['USD'] ?? 1;
            $fromUSD = 1 / (self::FALLBACK_RATES['USD'][$toCurrency] ?? 1);
            return $toUSD * $fromUSD;
        }
        
        return 1;
    }
    
    public function calculateFee($amount, $currency) {
        $feePercentage = 0.007; // 0.7%
        $fee = $amount * $feePercentage;
        
        $minFees = [
            'AUD' => 0.50,
            'USD' => 0.50,
            'EUR' => 0.50,
            'GBP' => 0.50,
            'NGN' => 50,
            'INR' => 10
        ];
        
        $minFee = $minFees[$currency] ?? 0.50;
        return max($fee, $minFee);
    }
    
    public function calculateTransfer($sendAmount, $fromCurrency, $toCurrency) {
        $exchangeRate = $this->getLiveRate($fromCurrency, $toCurrency);
        $fee = $this->calculateFee($sendAmount, $fromCurrency);
        $amountAfterFee = $sendAmount - $fee;
        $receiveAmount = round($amountAfterFee * $exchangeRate, 2);
        
        return [
            'sendAmount' => $sendAmount,
            'fee' => $fee,
            'exchangeRate' => $exchangeRate,
            'amountAfterFee' => $amountAfterFee,
            'receiveAmount' => $receiveAmount
        ];
    }
}

