<?php
/**
 * Get all HTTP headers
 * Works in both Apache and CLI environments
 * Uses ONLY $_SERVER to avoid any recursion issues
 */
function getAllHeaders() {
    $headers = [];
    
    // Build headers ONLY from $_SERVER - no function calls that could cause recursion
    foreach ($_SERVER as $name => $value) {
        if (substr($name, 0, 5) == 'HTTP_') {
            $headerName = str_replace(' ', '-', ucwords(strtolower(str_replace('_', ' ', substr($name, 5)))));
            $headers[$headerName] = $value;
        }
    }
    
    // Check for Authorization header in various $_SERVER locations
    if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
        $headers['Authorization'] = $_SERVER['HTTP_AUTHORIZATION'];
    } elseif (isset($_SERVER['REDIRECT_HTTP_AUTHORIZATION'])) {
        $headers['Authorization'] = $_SERVER['REDIRECT_HTTP_AUTHORIZATION'];
    } elseif (isset($_SERVER['Authorization'])) {
        $headers['Authorization'] = $_SERVER['Authorization'];
    }
    
    return $headers;
}

/**
 * Get Authorization header value
 * Direct access ONLY - no function calls to avoid recursion
 */
function getAuthHeader() {
    // Check $_SERVER directly - no function calls
    if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
        return $_SERVER['HTTP_AUTHORIZATION'];
    }
    if (isset($_SERVER['REDIRECT_HTTP_AUTHORIZATION'])) {
        return $_SERVER['REDIRECT_HTTP_AUTHORIZATION'];
    }
    if (isset($_SERVER['Authorization'])) {
        return $_SERVER['Authorization'];
    }
    
    // Check query parameter as fallback
    if (isset($_GET['sessionId'])) {
        return $_GET['sessionId'];
    }
    
    // Last resort: check all HTTP_ headers manually
    foreach ($_SERVER as $name => $value) {
        if ($name === 'HTTP_AUTHORIZATION' || $name === 'REDIRECT_HTTP_AUTHORIZATION') {
            return $value;
        }
    }
    
    return '';
}


