<?php
// Start output buffering IMMEDIATELY to catch any unexpected output
ob_start();

// Set headers FIRST - before ANY output (critical for InfinityFree)
header('Content-Type: application/json; charset=utf-8');
header('X-Content-Type-Options: nosniff');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');

// Only accept POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    ob_clean(); // Clear any output
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

// Suppress any warnings/notices that might cause output
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);

// Start session
session_start();

// TEMPORARY: Skip authentication - just return success
$input = json_decode(file_get_contents('php://input'), true);
$username = $input['username'] ?? 'test';

// Set session user ID (this is what dashboard.php will check)
$_SESSION['user_id'] = 1; // Default user ID for testing

// Clear any output before sending response
ob_clean();

// Return success without authentication
echo json_encode([
    'success' => true,
    'user' => [
        'id' => 1,
        'username' => $username,
        'full_name' => 'Test User',
        'email' => 'test@example.com'
    ],
    'sessionId' => session_id()
]);
exit;

