<?php
// Set headers FIRST - before ANY output (critical for InfinityFree)
header('Content-Type: application/json; charset=utf-8');
header('X-Content-Type-Options: nosniff');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');

// Security: Only allow from localhost or specific IPs
$allowedIPs = ['127.0.0.1', '::1', 'localhost'];
$clientIP = $_SERVER['REMOTE_ADDR'] ?? '';

// Allow if localhost or if running on a development server
$isLocalhost = in_array($clientIP, $allowedIPs) || 
               strpos($_SERVER['HTTP_HOST'] ?? '', 'localhost') !== false ||
               strpos($_SERVER['HTTP_HOST'] ?? '', '127.0.0.1') !== false;

// For production, you might want to add password protection
// For now, we'll allow it but you can add authentication later

$script = $_GET['script'] ?? '';

$allowedScripts = [
    'create-user' => __DIR__ . '/../scripts/create-user.php',
    'check-user' => __DIR__ . '/../scripts/check-user.php',
    'system-info' => 'system-info' // Special case, handled below
];

if (!isset($allowedScripts[$script])) {
    echo json_encode([
        'success' => false,
        'error' => 'Invalid script name'
    ]);
    exit;
}

// Special handling for system-info
if ($script === 'system-info') {
    ob_start();
    require_once __DIR__ . '/system-info.php';
    $output = ob_get_clean();
    echo json_encode([
        'success' => true,
        'output' => $output
    ]);
    exit;
}

$scriptPath = $allowedScripts[$script];

if (!file_exists($scriptPath)) {
    echo json_encode([
        'success' => false,
        'error' => 'Script file not found: ' . $scriptPath
    ]);
    exit;
}

// Capture output
ob_start();

try {
    // Run the script and capture output
    include $scriptPath;
    $output = ob_get_clean();
    
    echo json_encode([
        'success' => true,
        'output' => $output
    ]);
} catch (Exception $e) {
    $output = ob_get_clean();
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage(),
        'output' => $output
    ]);
}

