<?php
// System information script

$info = [];

// PHP Version
$info[] = "PHP Version: " . PHP_VERSION;
$info[] = "";

// Server Information
$info[] = "Server Software: " . ($_SERVER['SERVER_SOFTWARE'] ?? 'Unknown');
$info[] = "Document Root: " . ($_SERVER['DOCUMENT_ROOT'] ?? 'Unknown');
$info[] = "";

// Database Check (PostgreSQL)
$info[] = "Database Type: PostgreSQL";
$info[] = "Database Name: " . (defined('DB_NAME') ? DB_NAME : 'Not configured');
$info[] = "";

// PHP Extensions
$requiredExtensions = ['pdo', 'pdo_pgsql', 'json', 'mbstring'];
$info[] = "Required PHP Extensions:";
foreach ($requiredExtensions as $ext) {
    $loaded = extension_loaded($ext);
    $status = $loaded ? "✅" : "❌";
    $info[] = "  {$status} {$ext}";
}
$info[] = "";

// Directory Permissions
$dirs = [
    'database' => __DIR__ . '/../database',
    'api' => __DIR__ . '/..',
];
$info[] = "Directory Permissions:";
foreach ($dirs as $name => $path) {
    if (is_dir($path)) {
        $writable = is_writable($path) ? "✅" : "❌";
        $info[] = "  {$writable} {$name}/ - " . (is_writable($path) ? "Writable" : "Not writable");
    } else {
        $info[] = "  ❌ {$name}/ - Does not exist";
    }
}
$info[] = "";

// User Account Check
try {
    require_once __DIR__ . '/db.php';
    require_once __DIR__ . '/auth.php';
    
    $db = new Database();
    $user = $db->getUserByUsername('shante99');
    
    if ($user) {
        $info[] = "✅ User account 'shante99' exists";
        $balance = $db->getAccountBalance($user['id'], 'AUD');
        $info[] = "   Balance: " . number_format($balance, 2) . " AUD";
    } else {
        $info[] = "❌ User account 'shante99' not found";
        $info[] = "   Run 'Create User Account' to set it up";
    }
} catch (Exception $e) {
    $info[] = "❌ Error checking user account: " . $e->getMessage();
}

function formatBytes($bytes, $precision = 2) {
    $units = array('B', 'KB', 'MB', 'GB', 'TB');
    $bytes = max($bytes, 0);
    $pow = floor(($bytes ? log($bytes) : 0) / log(1024));
    $pow = min($pow, count($units) - 1);
    $bytes /= pow(1024, $pow);
    return round($bytes, $precision) . ' ' . $units[$pow];
}

echo implode("\n", $info);

