<?php
// Test endpoint to verify headers are working
// Access this directly in browser: https://your-site.42web.io/api/test-headers.php

// Start output buffering IMMEDIATELY
ob_start();

// Set headers FIRST
header('Content-Type: application/json; charset=utf-8');
header('X-Content-Type-Options: nosniff');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');

// Clear any output
ob_clean();

echo json_encode([
    'success' => true,
    'message' => 'Headers are working correctly',
    'method' => $_SERVER['REQUEST_METHOD'] ?? 'UNKNOWN',
    'headers_sent' => headers_sent(),
    'output_buffer_level' => ob_get_level()
]);

