<?php
/**
 * Test MySQL Connection
 * Run this file to verify your MySQL database connection
 */
header('Content-Type: text/plain');

echo "Testing MySQL Connection...\n\n";

try {
    require_once __DIR__ . '/db-config.php';
    require_once __DIR__ . '/db.php';
    
    echo "✅ Configuration loaded\n";
    echo "Database Type: " . DB_TYPE . "\n";
    echo "Database Name: " . DB_NAME . "\n";
    echo "Database User: " . DB_USER . "\n\n";
    
    echo "Connecting to database...\n";
    $db = new Database();
    
    echo "✅ Database connection successful!\n\n";
    
    // Test query
    echo "Testing database query...\n";
    $stmt = $db->db->query("SELECT 1 as test");
    $result = $stmt->fetch();
    echo "✅ Query test successful!\n\n";
    
    // Check if tables exist
    echo "Checking tables...\n";
    $tables = ['users', 'accounts', 'transfers'];
    foreach ($tables as $table) {
        $stmt = $db->db->query("SHOW TABLES LIKE '$table'");
        if ($stmt->rowCount() > 0) {
            echo "✅ Table '$table' exists\n";
        } else {
            echo "⚠️  Table '$table' does not exist (will be created on first use)\n";
        }
    }
    
    echo "\n✅ All tests passed! MySQL is ready to use.\n";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
    echo "\nPlease check:\n";
    echo "1. Database credentials in api/db-config.php\n";
    echo "2. Database exists in phpMyAdmin\n";
    echo "3. User has proper permissions\n";
    exit(1);
}

