<?php
// Set headers FIRST - before ANY output (critical for InfinityFree)
header('Content-Type: application/json; charset=utf-8');
header('X-Content-Type-Options: nosniff');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
require_once 'session.php';
require_once 'transferService.php';
require_once 'helpers.php';

// Get session ID from Authorization header or query param
$sessionId = getAuthHeader();
$userId = SessionManager::getUserId($sessionId);

if (!$userId) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

try {
    $transferService = new TransferService();
    $transfers = $transferService->getTransferHistory($userId);
    echo json_encode(['transfers' => $transfers]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}

