<?php
require_once __DIR__ . '/../api/db.php';
require_once __DIR__ . '/../api/auth.php';

$username = 'shante99';
$password = 'Shantel9921//';

echo "Checking user account...\n\n";

try {
    $db = new Database();
    $auth = new Auth();
    
    // Check if user exists
    $user = $db->getUserByUsername($username);
    
    if (!$user) {
        echo "❌ User '{$username}' NOT FOUND in database!\n";
        echo "\nPlease run: php scripts/create-user.php\n";
        exit(1);
    }
    
    echo "✅ User found!\n";
    echo "User ID: {$user['id']}\n";
    echo "Full Name: {$user['full_name']}\n";
    echo "Username: {$user['username']}\n";
    echo "Email: {$user['email']}\n";
    echo "Password Hash: " . substr($user['password'], 0, 20) . "...\n\n";
    
    // Test password
    echo "Testing password...\n";
    $isMatch = $auth->comparePassword($password, $user['password']);
    
    if ($isMatch) {
        echo "✅ Password is CORRECT!\n\n";
    } else {
        echo "❌ Password is INCORRECT!\n";
        echo "The stored password hash does not match the provided password.\n";
        echo "Please run: php scripts/create-user.php\n";
        exit(1);
    }
    
    // Check account balance
    $balance = $db->getAccountBalance($user['id'], 'AUD');
    echo "Account Balance: {$balance} AUD\n\n";
    
    // Test authentication
    echo "Testing authentication...\n";
    $authenticatedUser = $auth->authenticateUser($username, $password);
    
    if ($authenticatedUser) {
        echo "✅ Authentication SUCCESSFUL!\n";
        echo "User can login with:\n";
        echo "  Username: {$username}\n";
        echo "  Password: {$password}\n";
    } else {
        echo "❌ Authentication FAILED!\n";
        exit(1);
    }
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
    exit(1);
}

