<?php
require_once __DIR__ . '/../api/db.php';
require_once __DIR__ . '/../api/auth.php';

$fullName = 'Shantelle Margret Dixon';
$username = 'shante99';
$email = 'shantelle@wise.com';
$password = 'Shantel9921//';
$initialBalance = 8899276.66;

echo "Creating account for: {$fullName}\n";
echo "Username: {$username}\n";
echo "Email: {$email}\n";
echo "Initial balance: {$initialBalance} AUD\n\n";

try {
    $db = new Database();
    $auth = new Auth();
    
    // Check if user already exists by username
    $existingUser = $db->getUserByUsername($username);
    if ($existingUser) {
        echo "User already exists. Updating password and balance...\n";
        
        // Update password (plain text)
        $stmt = $db->db->prepare("UPDATE users SET password = ? WHERE id = ?");
        $stmt->execute([$password, $existingUser['id']]);
        
        // Ensure AUD account exists
        $account = $db->db->prepare("SELECT * FROM accounts WHERE user_id = ? AND currency = 'AUD'");
        $account->execute([$existingUser['id']]);
        $accountData = $account->fetch(PDO::FETCH_ASSOC);
        
        if (!$accountData) {
            // Create AUD account if it doesn't exist
            $stmt = $db->db->prepare("INSERT INTO accounts (user_id, currency, balance) VALUES (?, ?, ?)");
            $stmt->execute([$existingUser['id'], 'AUD', $initialBalance]);
            echo "Created AUD account with balance: {$initialBalance}\n";
        } else {
            // Set balance to exact amount (not add to existing)
            $stmt = $db->db->prepare("UPDATE accounts SET balance = ? WHERE user_id = ? AND currency = 'AUD'");
            $stmt->execute([$initialBalance, $existingUser['id']]);
            echo "Updated balance to: {$initialBalance} AUD\n";
        }
        
        echo "Password and balance updated successfully!\n";
        echo "User ID: {$existingUser['id']}\n";
        echo "\n✅ Account updated successfully!\n";
        echo "\nLogin credentials:\n";
        echo "Username: {$username}\n";
        echo "Password: {$password}\n";
        exit;
    }
    
    // Check if user exists by email
    $existingUser = $db->getUserByEmail($email);
    if ($existingUser) {
        echo "User exists by email. Updating username, password and balance...\n";
        
        // Update username and password (plain text)
        $stmt = $db->db->prepare("UPDATE users SET username = ?, password = ? WHERE id = ?");
        $stmt->execute([$username, $password, $existingUser['id']]);
        
        // Ensure AUD account exists
        $account = $db->db->prepare("SELECT * FROM accounts WHERE user_id = ? AND currency = 'AUD'");
        $account->execute([$existingUser['id']]);
        $accountData = $account->fetch(PDO::FETCH_ASSOC);
        
        if (!$accountData) {
            // Create AUD account if it doesn't exist
            $stmt = $db->db->prepare("INSERT INTO accounts (user_id, currency, balance) VALUES (?, ?, ?)");
            $stmt->execute([$existingUser['id'], 'AUD', $initialBalance]);
            echo "Created AUD account with balance: {$initialBalance}\n";
        } else {
            // Set balance to exact amount (not add to existing)
            $stmt = $db->db->prepare("UPDATE accounts SET balance = ? WHERE user_id = ? AND currency = 'AUD'");
            $stmt->execute([$initialBalance, $existingUser['id']]);
            echo "Updated balance to: {$initialBalance} AUD\n";
        }
        
        echo "Username, password and balance updated successfully!\n";
        echo "User ID: {$existingUser['id']}\n";
        echo "\n✅ Account updated successfully!\n";
        echo "\nLogin credentials:\n";
        echo "Username: {$username}\n";
        echo "Password: {$password}\n";
        exit;
    }
    
    // Create new user
    $user = $auth->registerUser($fullName, $username, $email, $password);
    echo "User created successfully!\n";
    echo "User ID: {$user['id']}\n";
    
    // Set initial balance (account was created with 0, so we set it to the exact amount)
    $stmt = $db->db->prepare("UPDATE accounts SET balance = ? WHERE user_id = ? AND currency = 'AUD'");
    $stmt->execute([$initialBalance, $user['id']]);
    echo "Initial balance set to: {$initialBalance} AUD\n";
    
    echo "\n✅ Account created successfully!\n";
    echo "\nLogin credentials:\n";
    echo "Username: {$username}\n";
    echo "Password: {$password}\n";
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    exit(1);
}

