<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Wise.com - Setup & Utilities</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            background: white;
            border-radius: 12px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            overflow: hidden;
        }
        
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 30px;
            text-align: center;
        }
        
        .header h1 {
            font-size: 28px;
            margin-bottom: 10px;
        }
        
        .content {
            padding: 30px;
        }
        
        .section {
            margin-bottom: 40px;
            padding: 20px;
            background: #f8f9fa;
            border-radius: 8px;
        }
        
        .section h2 {
            color: #333;
            margin-bottom: 20px;
            font-size: 22px;
            border-bottom: 2px solid #667eea;
            padding-bottom: 10px;
        }
        
        .btn {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            padding: 12px 24px;
            border-radius: 6px;
            cursor: pointer;
            font-size: 16px;
            font-weight: 600;
            transition: transform 0.2s, box-shadow 0.2s;
            margin-right: 10px;
            margin-bottom: 10px;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }
        
        .btn:active {
            transform: translateY(0);
        }
        
        .btn-success {
            background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);
        }
        
        .btn-danger {
            background: linear-gradient(135deg, #eb3349 0%, #f45c43 100%);
        }
        
        .output {
            background: #1e1e1e;
            color: #d4d4d4;
            padding: 20px;
            border-radius: 6px;
            font-family: 'Courier New', monospace;
            font-size: 14px;
            line-height: 1.6;
            margin-top: 20px;
            max-height: 400px;
            overflow-y: auto;
            white-space: pre-wrap;
            word-wrap: break-word;
        }
        
        .output.success {
            background: #0d2818;
            color: #4ade80;
        }
        
        .output.error {
            background: #2d1b1b;
            color: #f87171;
        }
        
        .file-list {
            list-style: none;
            padding: 0;
        }
        
        .file-item {
            padding: 12px;
            margin-bottom: 8px;
            background: white;
            border-left: 4px solid #667eea;
            border-radius: 4px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .file-path {
            font-family: 'Courier New', monospace;
            color: #333;
            flex: 1;
        }
        
        .file-date {
            color: #666;
            font-size: 12px;
            margin-left: 15px;
        }
        
        .status {
            display: inline-block;
            padding: 4px 12px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 600;
            margin-left: 10px;
        }
        
        .status.success {
            background: #d1fae5;
            color: #065f46;
        }
        
        .status.error {
            background: #fee2e2;
            color: #991b1b;
        }
        
        .loading {
            display: inline-block;
            width: 16px;
            height: 16px;
            border: 2px solid #f3f3f3;
            border-top: 2px solid #667eea;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin-left: 10px;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        .info-box {
            background: #e0f2fe;
            border-left: 4px solid #0ea5e9;
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 4px;
        }
        
        .info-box strong {
            color: #0c4a6e;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🔧 Wise.com Setup & Utilities</h1>
            <p>Manage your banking platform setup</p>
        </div>
        
        <div class="content">
            <!-- Database Setup Section -->
            <div class="section">
                <h2>📦 Database Setup</h2>
                <div class="info-box">
                    <strong>Create User Account:</strong> This will create the database (if needed) and set up the account for Shantelle Margret Dixon with username <code>shante99</code> and password <code>Shantel9921//</code>
                </div>
                <button class="btn btn-success" onclick="runScript('create-user')">
                    ✅ Create User Account
                </button>
                <button class="btn" onclick="runScript('check-user')">
                    🔍 Check User Account
                </button>
                <div id="output-create-user" class="output" style="display:none;"></div>
            </div>
            
            <!-- File Changes Section -->
            <div class="section">
                <h2>📁 Recently Changed Files</h2>
                <button class="btn" onclick="loadChangedFiles()">
                    🔄 Refresh File List
                </button>
                <div id="file-list-container">
                    <div class="output" style="background: #f8f9fa; color: #666;">
                        Click "Refresh File List" to see recently modified files
                    </div>
                </div>
            </div>
            
            <!-- System Info Section -->
            <div class="section">
                <h2>ℹ️ System Information</h2>
                <button class="btn" onclick="runScript('system-info')">
                    📊 Show System Info
                </button>
                <div id="output-system-info" class="output" style="display:none;"></div>
            </div>
        </div>
    </div>
    
    <script>
        async function runScript(scriptName) {
            const outputId = `output-${scriptName}`;
            const outputDiv = document.getElementById(outputId);
            outputDiv.style.display = 'block';
            outputDiv.className = 'output';
            outputDiv.textContent = 'Running...';
            
            try {
                const response = await fetch(`api/run-script.php?script=${scriptName}`, {
                  headers: {
                    'Accept': 'application/json'
                  }
                });
                const responseText = await response.text();
                if (responseText.trim().startsWith('<')) {
                  throw new Error('Server returned HTML instead of JSON (hosting protection triggered).');
                }
                const data = JSON.parse(responseText);
                
                if (data.success) {
                    outputDiv.className = 'output success';
                    outputDiv.textContent = data.output;
                } else {
                    outputDiv.className = 'output error';
                    outputDiv.textContent = data.error || 'An error occurred';
                }
            } catch (error) {
                outputDiv.className = 'output error';
                outputDiv.textContent = 'Error: ' + error.message;
            }
        }
        
        async function loadChangedFiles() {
            const container = document.getElementById('file-list-container');
            container.innerHTML = '<div class="loading"></div> Loading...';
            
            try {
                const response = await fetch('api/changed-files.php', {
                  headers: {
                    'Accept': 'application/json'
                  }
                });
                const responseText = await response.text();
                if (responseText.trim().startsWith('<')) {
                  throw new Error('Server returned HTML instead of JSON (hosting protection triggered).');
                }
                const data = JSON.parse(responseText);
                
                if (data.success) {
                    if (data.files.length === 0) {
                        container.innerHTML = '<div class="output" style="background: #f8f9fa; color: #666;">No recently changed files found</div>';
                    } else {
                        let html = '<ul class="file-list">';
                        data.files.forEach(file => {
                            const date = new Date(file.modified * 1000).toLocaleString();
                            html += `
                                <li class="file-item">
                                    <span class="file-path">${file.path}</span>
                                    <span class="file-date">${date}</span>
                                </li>
                            `;
                        });
                        html += '</ul>';
                        container.innerHTML = html;
                    }
                } else {
                    container.innerHTML = `<div class="output error">Error: ${data.error}</div>`;
                }
            } catch (error) {
                container.innerHTML = `<div class="output error">Error: ${error.message}</div>`;
            }
        }
        
        // Auto-load changed files on page load
        window.addEventListener('load', () => {
            loadChangedFiles();
        });
    </script>
</body>
</html>

