function toggleAttr(element, cuLabel, label1, label2) {
  if (!element) return;

  const currentLabel = element.attr(cuLabel);
  const newLabel = currentLabel === label1 ? label2 : label1;
  element.attr(cuLabel, newLabel);
}
const showPassBtt = $(".show-password-btn");
const passInp = $("#password");
const menuBtt = $(".generic-menu-item__chevron-button");
const menuIttm = $(".menu-submenu__expandable-container");
const featBtt = $(".features");
const featIttm = $(".feat-items");

showPassBtt.click(() => {
  toggleAttr(showPassBtt, "aria-pressed", "false", "true");
  const currentType = passInp.attr("type");
  passInp.attr("type", currentType === "password" ? "text" : "password");
});

featBtt.hover(() => {
  toggleAttr(featBtt, "aria-expanded", "false", "true");
  featIttm.toggleClass("hidden");
});

menuBtt.click(() => {
  toggleAttr(menuBtt, "aria-expanded", "false", "true");
  menuIttm.toggleClass("expanded");
});

function disableLinkUntilInputFilled(inputSelector, linkSelector) {
  const input = document.querySelector(inputSelector);
  const link = document.querySelector(linkSelector);

  if (!input || !link) return;

  // Initial state
  link.classList.toggle("disabled-link", input.value.trim() === "");

  input.addEventListener("input", () => {
    const isEmpty = input.value.trim() === "";
    link.classList.toggle("disabled-link", isEmpty);
  });
}

// Note: Login page uses #username and #loginBtn (button), not #email and .login (link)
// disableLinkUntilInputFilled is not needed for current login structure
